﻿using log4net;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.Reflection;
using System.Xml;
using VA.PPMS.IWS.Api.Configuration;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.Formatters;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;
using VA.PPMS.IWS.Api.Middleware;

namespace VA.PPMS.IWS.Api
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        public void ConfigureServices(IServiceCollection services)
        {
            services.AddMvc(options =>
            {
                options.InputFormatters.Add(new FhirInputFormatter());
                options.InputFormatters.Add(new StreamInputFormatter());
            });

            var doc = new XmlDocument();
            doc.LoadXml(Configuration["IwsSettings:Log4NetConfigSettings"]);
            var element = doc.DocumentElement;
            var repo = LogManager.CreateRepository(Assembly.GetEntryAssembly(), typeof(log4net.Repository.Hierarchy.Hierarchy));
            log4net.Config.XmlConfigurator.Configure(repo, element);

            var log = LogManager.GetLogger(typeof(Controller));

            services.AddSingleton(log);
            services.AddSingleton<IIwsConfiguration, IwsConfiguration>();
            services.AddTransient<IHttpClientHandler, HttpClientHandler.HttpClientHandler>();
        }

        public void Configure(IApplicationBuilder app, IHostingEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }

            var checkifCertRequired = Convert.ToBoolean(Configuration["IwsSettings:CertRequired"]);
            if (checkifCertRequired) app.UseClientCertificateValidator();

            app.UseMvc();
        }
    }
}